package gov.va.vamf.scheduling.direct.domain;

import agilex.commons.NullChecker;
import com.agilex.healthcare.veteranappointment.domain.Namespace;
import org.springframework.data.annotation.Id;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(namespace = Namespace.DirectScheduling)
public class CoreSetting {
    @Id
    @XmlElement
    private String id;
    @XmlElement
    private String  typeOfCare;
    @XmlElement
    private String  patientHistoryRequired;
    @XmlElement
    private Integer patientHistoryDuration;
    @XmlElement
    private int submittedRequestLimit;

    public CoreSetting() {
    }

    public CoreSetting(String id, String typeOfCare, String patientHistoryRequired, Integer patientHistoryDuration) {
        this.id = id;
        this.typeOfCare = typeOfCare;
        this.patientHistoryRequired = patientHistoryRequired;
        this.patientHistoryDuration = patientHistoryDuration;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTypeOfCare() {
        return typeOfCare;
    }

    public void setTypeOfCare(String typeOfCare) {
        this.typeOfCare = typeOfCare;
    }

    public String getPatientHistoryRequired() {
        return patientHistoryRequired;
    }

    public void setPatientHistoryRequired(String patientHistoryRequired) {
        this.patientHistoryRequired = patientHistoryRequired;
    }

    public Integer getPatientHistoryDuration() {
        return patientHistoryDuration;
    }

    public void setPatientHistoryDuration(Integer patientHistoryDuration) {
        this.patientHistoryDuration = patientHistoryDuration;
    }

    public int getSubmittedRequestLimit() {
        return submittedRequestLimit;
    }

    public void setSubmittedRequestLimit(int submittedRequestLimit) {
        this.submittedRequestLimit = submittedRequestLimit;
    }

    public boolean isEnabled() {
        return NullChecker.isNotNullish(patientHistoryRequired);
    }
}
